
import gurobipy as gp

# Create a new model
m = gp.Model("Bakery Optimization")

# Create decision variables
x1 = m.addVar(lb=0, name="regular_donuts")  # Number of regular donuts
x2 = m.addVar(lb=0, name="jelly_donuts")  # Number of jelly donuts

# Set objective function: Maximize profit
m.setObjective(2 * x1 + 4 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 100, "demand_regular")  # Demand for regular donuts
m.addConstr(x2 <= 75, "demand_jelly")  # Demand for jelly donuts
m.addConstr(x1 + x2 <= 120, "capacity")  # Production capacity

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular donuts (x1): {x1.x}")
    print(f"Number of jelly donuts (x2): {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

