
from gurobipy import *

# Create a new model
model = Model("Bakery_Optimization")

# Add variables to the model
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_donuts")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="jelly_filled_donuts")

# Set the objective function
model.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 100, "regular_donut_demand")
model.addConstr(x2 <= 75, "jelly_filled_donut_demand")
model.addConstr(x1 + x2 <= 120, "total_production_capacity")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular donuts to produce: {x1.x}")
    print(f"Jelly filled donuts to produce: {x2.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
