
import gurobi

def solve_bakery_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="regular_donuts")
    x2 = model.addVar(lb=0, name="jelly_filled_donuts")

    # Define the objective function
    model.setObjective(2*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(x1 <= 100, name="demand_regular")
    model.addConstr(x2 <= 75, name="demand_jelly")
    model.addConstr(x1 + x2 <= 120, name="capacity")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Produce {x1.varValue} regular donuts per day.")
        print(f"Produce {x2.varValue} jelly filled donuts per day.")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_bakery_problem()
