
import gurobipy as gp

# Create a new model
m = gp.Model("john_diet")

# Create variables
rice = m.addVar(lb=0, name="rice")  # Servings of rice
beef = m.addVar(lb=0, name="beef")  # Servings of beef

# Set objective function: Minimize total cost
m.setObjective(5 * rice + 30 * beef, gp.GRB.MINIMIZE)

# Add constraints: Macronutrient requirements
m.addConstr(2 * rice + 20 * beef >= 50, "protein_req")
m.addConstr(80 * rice + 200 * beef >= 1000, "carbs_req")
m.addConstr(1 * rice + 16 * beef >= 40, "fat_req")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Servings of rice: {rice.x:.2f}")
    print(f"Servings of beef: {beef.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

