
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="servings_of_rice")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="servings_of_beef")

# Set the objective function
m.setObjective(5*x1 + 30*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 20*x2 >= 50, "protein_constraint")
m.addConstr(80*x1 + 200*x2 >= 1000, "carbs_constraint")
m.addConstr(x1 + 16*x2 >= 40, "fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of rice: {x1.x}")
    print(f"Servings of beef: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
