
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="rice", lb=0)
x2 = m.addVar(name="beef", lb=0)

# Define the objective function
m.setObjective(5 * x1 + 30 * x2, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(2 * x1 + 20 * x2 >= 50, name="protein")
m.addConstr(80 * x1 + 200 * x2 >= 1000, name="carbs")
m.addConstr(x1 + 16 * x2 >= 40, name="fat")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Servings of rice: {x1.x}")
    print(f"Servings of beef: {x2.x}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
