
import gurobipy as gp

# Create a new model
model = gp.Model("Factory_Layout")

# Create decision variables
headset_space = model.addVar(lb=0, name="headset_space")  # x1
keyboard_space = model.addVar(lb=0, name="keyboard_space") # x2

# Set objective function
model.setObjective(45 * headset_space + 80 * keyboard_space, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(headset_space + keyboard_space <= 120, "space_constraint")
model.addConstr(2.5 * headset_space + 3.5 * keyboard_space <= 2500, "labor_constraint")
model.addConstr(10 * headset_space + 12 * keyboard_space <= 5500, "cost_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${model.objVal:.2f}")
    print(f"Headset Space: {headset_space.x:.2f} sq. ft.")
    print(f"Keyboard Space: {keyboard_space.x:.2f} sq. ft.")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

