
from gurobipy import *

# Create a new model
m = Model("Factory_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="headsets_space")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="keyboards_space")

# Set objective function: Maximize revenue
m.setObjective(45*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 120, "space_constraint")
m.addConstr(2.5*x1 + 3.5*x2 <= 2500, "labor_hours_constraint")
m.addConstr(10*x1 + 12*x2 <= 5500, "cost_constraint")
m.addConstr(x1 >= 0, "non_neg_headsets")
m.addConstr(x2 >= 0, "non_neg_keyboards")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Headsets space: {x1.x} sq. feet")
    print(f"Keyboards space: {x2.x} sq. feet")
    print(f"Maximum revenue: ${m.objVal}")
else:
    print("No optimal solution found.")
