
import gurobi

def optimize_factory_layout():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="headset_sq_feet", lb=0)
    x2 = model.addVar(name="keyboard_sq_feet", lb=0)

    # Objective function: maximize revenue
    model.setObjective(45 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 120, name="space_constraint")
    model.addConstr(10 * x1 + 12 * x2 <= 5500, name="cost_constraint")
    model.addConstr(2.5 * x1 + 3.5 * x2 <= 2500, name="labor_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Headset sq. feet: {x1.varValue}")
        print(f"Keyboard sq. feet: {x2.varValue}")
        print(f"Max revenue: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_factory_layout()
