
import gurobipy as gp

# Create a new model
model = gp.Model("SupplementationOptimization")

# Create decision variables
zeta = model.addVar(lb=0, name="zeta")  # Grams of Zeta supplementation
phi = model.addVar(lb=0, name="phi")  # Grams of Phi supplementation

# Set objective function: Minimize cost
model.setObjective(0.08 * zeta + 0.18 * phi, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(0.15 * zeta + 0.20 * phi >= 25, "IronRequirement")  # Iron constraint
model.addConstr(0.20 * zeta + 0.45 * phi >= 40, "VitaminARequirement")  # Vitamin A constraint

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Zeta supplementation: {zeta.x:.2f} grams")
    print(f"  Phi supplementation: {phi.x:.2f} grams")
    print(f"  Total cost: ${model.objVal:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists that satisfies all constraints.")
else:
    print(f"Optimization terminated with status: {model.status}")

