
from gurobipy import *

# Create a new model
m = Model("Daniel_Supplementation")

# Add variables to the model
x1 = m.addVar(lb=0, name="Zeta_Supplementation")
x2 = m.addVar(lb=0, name="Phi_Supplementation")

# Set the objective function
m.setObjective(0.08*x1 + 0.18*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(0.15*x1 + 0.20*x2 >= 25, name="Iron_Requirement")
m.addConstr(0.20*x1 + 0.45*x2 >= 40, name="VitaminA_Requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zeta supplementation: {x1.x} grams")
    print(f"Phi supplementation: {x2.x} grams")
    print(f"Total cost: ${0.08*x1.x + 0.18*x2.x}")
else:
    print("No optimal solution found.")
