
import gurobi

def solve_supplementation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Zeta_supplementation", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="Phi_supplementation", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(0.08 * x1 + 0.18 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.15 * x1 + 0.20 * x2 >= 25, name="Iron_requirement")
    model.addConstr(0.20 * x1 + 0.45 * x2 >= 40, name="Vitamin_A_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Zeta supplementation: {x1.varValue} grams")
        print(f"Phi supplementation: {x2.varValue} grams")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_supplementation_problem()
