
import gurobipy as gp

# Create a new model
model = gp.Model("Phone_Production")

# Create variables
large_phones = model.addVar(vtype=gp.GRB.CONTINUOUS, name="large_phones")  # x1
small_phones = model.addVar(vtype=gp.GRB.CONTINUOUS, name="small_phones")  # x2

# Set objective function
model.setObjective(400 * large_phones + 300 * small_phones, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * large_phones + 15 * small_phones <= 1500, "manufacturing_belt")
model.addConstr(12 * large_phones + 10 * small_phones <= 1000, "testing")
model.addConstr(large_phones >= 0, "large_phones_nonnegative")
model.addConstr(small_phones >= 0, "small_phones_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large phones to produce: {large_phones.x}")
    print(f"Number of small phones to produce: {small_phones.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

