
from gurobipy import *

# Create a new model
m = Model("phone_production")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_phones")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_phones")

# Set the objective function
m.setObjective(400*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 1500, "manufacturing_belt")
m.addConstr(12*x1 + 10*x2 <= 1000, "testing_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal production: {x1.varName} = {int(x1.x)}, {x2.varName} = {int(x2.x)}")
    print(f"Maximum profit: ${400*int(x1.x) + 300*int(x2.x)}")
else:
    print("No optimal solution found.")
