
import gurobipy as gp

# Create a new model
m = gp.Model("phone_production")

# Define variables
x1 = m.addVar(name="large_phones", lb=0, vtype=gp.GRB.INTEGER)  # Number of large size phones
x2 = m.addVar(name="small_phones", lb=0, vtype=gp.GRB.INTEGER)  # Number of small size phones

# Objective function: Maximize profit
m.setObjective(400*x1 + 300*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x1 + 15*x2 <= 1500, name="manufacturing_belt_constraint")
m.addConstr(12*x1 + 10*x2 <= 1000, name="testing_constraint")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Large phones = {x1.varValue}, Small phones = {x2.varValue}")
    print(f"Max Profit: ${400*x1.varValue + 300*x2.varValue}")
else:
    print("The model is infeasible.")
