
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Wood_Decor_Optimization")

# Create decision variables
x1 = model.addVar(vtype=GRB.INTEGER, name="vase_decor")  # Number of vase decors
x2 = model.addVar(vtype=GRB.INTEGER, name="wood_canvas") # Number of wood canvases

# Set objective function
model.setObjective(50*x1 + 85*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 18*x2 <= 400, "carving_constraint")
model.addConstr(14*x1 + 8*x2 <= 640, "polishing_constraint")
model.addConstr(x1 >= 0, "non_negativity_x1")
model.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Vase Decors (x1): {x1.x}")
    print(f"Number of Wood Canvases (x2): {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

