
from gurobipy import *

# Create a new model
m = Model("Wood_Decor_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="vase_decors")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="wood_canvases")

# Set the objective function
m.setObjective(50*x1 + 85*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 18*x2 <= 400, "carving_time")
m.addConstr(14*x1 + 8*x2 <= 640, "polishing_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of vase decors: {x1.x}")
    print(f"Number of wood canvases: {x2.x}")
    print(f"Total profit: ${50*x1.x + 85*x2.x}")
else:
    print("No optimal solution found")
