
import gurobipy as gp

# Create a new model
model = gp.Model("WoodArtist")

# Define variables
x1 = model.addVar(name="vase_decor", lb=0, vtype=gp.GRB.INTEGER)  # Number of vase décors
x2 = model.addVar(name="wood_canvas", lb=0, vtype=gp.GRB.INTEGER)  # Number of wood canvases

# Objective function: Maximize profit
model.setObjective(50*x1 + 85*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(20*x1 + 18*x2 <= 400, name="carving_time")  # Carving time constraint
model.addConstr(14*x1 + 8*x2 <= 640, name="polishing_time")  # Polishing time constraint

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${50*x1.varValue + 85*x2.varValue}")
else:
    print("No optimal solution found.")
