
import gurobipy as gp

# Create a new model
m = gp.Model("Fruit_Farming")

# Create variables
peaches = m.addVar(lb=0, name="peaches")  # Acres of peaches
nectarines = m.addVar(lb=0, name="nectarines")  # Acres of nectarines

# Set objective function
m.setObjective(200 * peaches + 175 * nectarines, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(peaches + nectarines <= 80, "Land_Constraint")  # Total land constraint
m.addConstr(3 * peaches + 4.5 * nectarines <= 300, "Planting_Constraint")  # Planting time constraint
m.addConstr(2 * peaches + 3 * nectarines <= 250, "Watering_Constraint")  # Watering time constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {peaches.x:.2f} acres of peaches")
    print(f"Plant {nectarines.x:.2f} acres of nectarines")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

