
from gurobipy import *

# Create a model
m = Model("Fruit_Farmer_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_peaches")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="acres_of_nectarines")

# Set objective function: Maximize profit
m.setObjective(200*x1 + 175*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 4.5*x2 <= 300, "planting_time_constraint")
m.addConstr(2*x1 + 3*x2 <= 250, "watering_time_constraint")
m.addConstr(x1 + x2 <= 80, "total_acres_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal acres of peaches: {x1.x}")
    print(f"Optimal acres of nectarines: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 175*x2.x:.2f}")
else:
    print("No optimal solution found")
