
import gurobi

def solve_fruit_farmer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, ub=80)  # acres of peaches
    x2 = model.addVar(name='x2', lb=0, ub=80)  # acres of nectarines

    # Set the objective function
    model.setObjective(200*x1 + 175*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 80, name='total_acres')
    model.addConstr(3*x1 + 4.5*x2 <= 300, name='planting_hours')
    model.addConstr(2*x1 + 3*x2 <= 250, name='watering_hours')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Acres of peaches = {x1.x}, Acres of nectarines = {x2.x}")
        print(f"Maximum profit: ${200*x1.x + 175*x2.x:.2f}")
    else:
        print("The model is infeasible")

solve_fruit_farmer_problem()
