
import gurobipy as gp

# Create a new model
model = gp.Model("Vehicle Production")

# Create variables
bikes = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bikes")
cars = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cars")

# Set objective function
model.setObjective(1000 * bikes + 3000 * cars, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1 * bikes + 3 * cars <= 10, "assembly_constraint")
model.addConstr(0.5 * bikes + 1 * cars <= 8, "painting_constraint")
model.addConstr(bikes >= 0, "bikes_nonnegative")
model.addConstr(cars >= 0, "cars_nonnegative")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Objective Value: {model.objVal}")
    print(f"Number of bikes to produce: {bikes.x}")
    print(f"Number of cars to produce: {cars.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

