
from gurobipy import *

# Create a new model
m = Model("Vehicle_Production")

# Define variables
x1 = m.addVar(name="bikes", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="cars", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(1000*x1 + 3000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 <= 10, name="assembly_machine")
m.addConstr(0.5*x1 + x2 <= 8, name="painting_machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x1.x:.2f} bikes and {x2.x:.2f} cars.")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
