
import gurobipy as gp

# Create a new model
model = gp.Model("Vehicle_Production")

# Define variables
x1 = model.addVar(name="bikes", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="cars", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: maximize profit
model.setObjective(1000*x1 + 3000*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + 3*x2 <= 10, name="assembly_machine")
model.addConstr(0.5*x1 + x2 <= 8, name="painting_machine")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bikes to produce: {x1.varValue}")
    print(f"Cars to produce: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
