
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("paint_blend")

# Create variables
x = model.addVar(lb=0, ub=1, name="cheap_paint_fraction") # fraction of cheap paint
y = model.addVar(lb=0, ub=1, name="expensive_paint_fraction") # fraction of expensive paint

# Set objective function: Minimize cost
model.setObjective(0.3 * x + 1.5 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(50 * x + 90 * y >= 80, "quality_constraint") # Quality requirement
model.addConstr(x + y == 1, "fraction_constraint") # Fractions must sum to 1

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal blend:")
    print(f"  Cheap paint fraction (x): {x.x}")
    print(f"  Expensive paint fraction (y): {y.x}")
    print(f"  Minimum cost: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

