
from gurobipy import *

# Create a new model
m = Model("Paint_Mix")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cheap_paint_fraction", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="expensive_paint_fraction", lb=0)

# Objective function: minimize cost
m.setObjective(0.30*x + 1.50*y, GRB.MINIMIZE)

# Constraints
m.addConstr(50*x + 90*y >= 80, "Quality_Constraint")
m.addConstr(x + y == 1, "Total_Fraction_Constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Fraction of cheap paint: {x.x}")
    print(f"Fraction of expensive paint: {y.x}")
    print(f"Minimum cost per liter: {m.objVal}")
else:
    print("No optimal solution found")
