
import gurobi

def solve_paint_blend_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cheap_paint", lb=0, ub=1)
    x2 = model.addVar(name="expensive_paint", lb=0, ub=1)

    # Set the objective function
    model.setObjective(0.30 * x1 + 1.50 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(50 * x1 + 90 * x2 >= 80, name="quality_constraint")
    model.addConstr(x1 + x2 == 1, name="fraction_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Fraction of cheap paint: {x1.x}")
        print(f"Fraction of expensive paint: {x2.x}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_paint_blend_problem()
