
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("clothing_store")

# Create variables
coats = m.addVar(lb=0, vtype=GRB.INTEGER, name="coats")
shirts = m.addVar(lb=0, vtype=GRB.INTEGER, name="shirts")

# Set objective function
m.setObjective(12 * coats + 8 * shirts, GRB.MAXIMIZE)

# Add constraints
m.addConstr(55 * coats + 25 * shirts <= 50000, "budget")
m.addConstr(coats >= 60, "min_coats")
m.addConstr(coats <= 100, "max_coats")
m.addConstr(shirts <= 4 * coats, "shirts_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of coats to sell: {coats.x}")
    print(f"Number of shirts to sell: {shirts.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

