
from gurobipy import *

# Create a new model
m = Model("Clothing_Store_Optimization")

# Define variables
x1 = m.addVar(name='coats_sold', lb=60, ub=100, vtype=GRB.INTEGER)
x2 = m.addVar(name='shirts_sold', lb=0, vtype=GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(12*x1 + 8*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(55*x1 + 25*x2 <= 50000, name='budget_constraint')
m.addConstr(x2 <= 4*x1, name='shirts_vs_coats')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coats sold: {x1.x}")
    print(f"Shirts sold: {x2.x}")
    print(f"Maximum profit: ${12*x1.x + 8*x2.x:.2f}")
else:
    print("No optimal solution found")

