
import gurobipy as gp

def solve_optimization_problem():
    # Create a new model
    model = gp.Model("clothing_store_optimization")

    # Define variables
    x1 = model.addVar(lb=60, ub=100, name="coats")  # Number of coats
    x2 = model.addVar(name="shirts")  # Number of shirts

    # Objective function: Maximize profit
    model.setObjective(12*x1 + 8*x2, gp.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(55*x1 + 25*x2 <= 50000, name="budget_constraint")

    # Shirts sold constraint
    model.addConstr(x2 <= 4*x1, name="shirts_sold_constraint")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: Coats = {x1.varValue}, Shirts = {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
