
import gurobipy as gp

# Create a new model
m = gp.Model("SyrupProduction")

# Create variables
chocolate = m.addVar(name="chocolate")
caramel = m.addVar(name="caramel")

# Set objective function
m.setObjective(500 * chocolate + 350 * caramel, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(chocolate <= 15, "chocolate_max")
m.addConstr(caramel <= 15, "caramel_max")
m.addConstr(chocolate >= 2, "chocolate_min")
m.addConstr(caramel >= 3, "caramel_min")
m.addConstr(3 * chocolate + 3 * caramel <= 50, "heating_machine")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal chocolate production: {chocolate.x} tons")
    print(f"Optimal caramel production: {caramel.x} tons")
    print(f"Optimal profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

