
from gurobipy import *

# Create a new model
m = Model("Syrup_Factory")

# Define variables
x1 = m.addVar(lb=2, ub=15, vtype=GRB.CONTINUOUS, name="chocolate_syrup")
x2 = m.addVar(lb=3, ub=15, vtype=GRB.CONTINUOUS, name="caramel_syrup")

# Set objective function
m.setObjective(500*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 15, "chocolate_limit")
m.addConstr(x2 <= 15, "caramel_limit")
m.addConstr(x1 >= 2, "min_chocolate")
m.addConstr(x2 >= 3, "min_caramel")
m.addConstr(3*x1 + 3*x2 <= 50, "heating_machine_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chocolate syrup: {x1.x} tons")
    print(f"Caramel syrup: {x2.x} tons")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
