
import gurobipy as gp

# Create a new model
model = gp.Model("Syrup_Factory_Optimization")

# Define variables
x1 = model.addVar(lb=2, ub=15, name="chocolate_syrup")  # tons of chocolate syrup
x2 = model.addVar(lb=3, ub=15, name="caramel_syrup")   # tons of caramel syrup

# Objective function: Maximize profit
model.setObjective(500*x1 + 350*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 15, name="chocolate_syrup_limit")
model.addConstr(x2 <= 15, name="caramel_syrup_limit")
model.addConstr(x1 >= 2, name="min_chocolate_syrup")
model.addConstr(x2 >= 3, name="min_caramel_syrup")
model.addConstr(3*x1 + 3*x2 <= 50, name="heating_machine_limit")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found")
