
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
corn = m.addVar(name="corn")
wheat = m.addVar(name="wheat")

# Set objective function
m.setObjective(200 * corn + 300 * wheat, GRB.MAXIMIZE)

# Add constraints
m.addConstr(corn + wheat <= 40, "total_land")
m.addConstr(corn >= 6, "min_corn")
m.addConstr(wheat >= 12, "min_wheat")
m.addConstr(corn <= 2 * wheat, "corn_wheat_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {corn.x} acres of corn")
    print(f"Plant {wheat.x} acres of wheat")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

