
from gurobipy import *

# Create a new model
m = Model("Farmer_Optimization")

# Define variables
x1 = m.addVar(name="acres_of_corn", lb=0)
x2 = m.addVar(name="acres_of_wheat", lb=0)

# Set the objective function
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 40, name="total_acres")
m.addConstr(x1 >= 6, name="min_corn")
m.addConstr(x2 >= 12, name="min_wheat")
m.addConstr(x1 <= 2*x2, name="corn_to_wheat_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of Corn: {x1.x}")
    print(f"Acres of Wheat: {x2.x}")
    print(f"Total Profit: ${200*x1.x + 300*x2.x:.2f}")
else:
    print("No optimal solution found")

