
import gurobipy as gp

# Create a new model
m = gp.Model("farmer")

# Define the variables
x1 = m.addVar(name="corn", lb=0)  # acres of corn
x2 = m.addVar(name="wheat", lb=0)  # acres of wheat

# Objective function: maximize profit
m.setObjective(200*x1 + 300*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 40, name="total_land")
m.addConstr(x1 >= 6, name="min_corn")
m.addConstr(x2 >= 12, name="min_wheat")
m.addConstr(x1 <= 2*x2, name="corn_vs_wheat")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of corn: {x1.varValue}")
    print(f"Optimal acres of wheat: {x2.varValue}")
    print(f"Maximum profit: ${200*x1.varValue + 300*x2.varValue}")
else:
    print("The model is infeasible")
