
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cereal_production")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="individual_cereal_box") # Number of individual cereal boxes
x2 = m.addVar(vtype=GRB.INTEGER, name="family_size_cereal_box") # Number of family size cereal boxes


# Set objective function
m.setObjective(4*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 60*x2 <= 2000, "cereal_constraint") # Cereal constraint
m.addConstr(10*x1 + 15*x2 <= 750, "time_constraint") # Time constraint
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of individual cereal boxes: {x1.x}")
    print(f"Number of family size cereal boxes: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

