
from gurobipy import *

# Create a new model
m = Model("Cereal_Boxes")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="individual_cereal_boxes")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="family_size_cereal_boxes")

# Set the objective function
m.setObjective(4*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 60*x2 <= 2000, "cereal_units")
m.addConstr(10*x1 + 15*x2 <= 750, "filling_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Individual cereal boxes: {x1.x}")
    print(f"Family size cereal boxes: {x2.x}")
    print(f"Maximum profit: ${4*x1.x + 8*x2.x}")
else:
    print("No optimal solution found")
