
import gurobi

def solve_cereal_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="individual_boxes", lb=0, ub=None)
    x2 = model.addVar(name="family_size_boxes", lb=0, ub=None)

    # Define the objective function
    model.setObjective(4 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(20 * x1 + 60 * x2 <= 2000, name="cereal_constraint")
    model.addConstr(10 * x1 + 15 * x2 <= 750, name="time_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of individual cereal boxes: {x1.varValue}")
        print(f"Number of family size cereal boxes: {x2.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_cereal_problem()
