
import gurobipy as gp

# Create a new model
m = gp.Model("cyclist_diet")

# Create variables
chicken = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")

# Set objective function
m.setObjective(6 * chicken + 2 * potatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * chicken + 2 * potatoes >= 80, "protein_req")
m.addConstr(4 * chicken + 3 * potatoes >= 50, "fat_req")
m.addConstr(4 * chicken + 7 * potatoes >= 100, "carb_req")


# Optimize model
m.optimize()

# Check if a solution was found
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Chicken: {chicken.x}')
    print(f'Potatoes: {potatoes.x}')
    print(f'Cost: ${m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}')

