
from gurobipy import *

# Create a new model
m = Model("Cyclist_Diet")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chickens")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")

# Set the objective function
m.setObjective(6*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x1 + 2*x2 >= 80, "protein")
m.addConstr(4*x1 + 3*x2 >= 50, "fat")
m.addConstr(4*x1 + 7*x2 >= 100, "carbs")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x1.x} chickens")
    print(f"Buy {x2.x} potatoes")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")

