
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="chicken", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="potato", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(6 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(20 * x1 + 2 * x2 >= 80, name="protein_constraint")
    model.addConstr(4 * x1 + 3 * x2 >= 50, name="fat_constraint")
    model.addConstr(4 * x1 + 7 * x2 >= 100, name="carbs_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of chickens: {x1.varValue}")
        print(f"Number of potatoes: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
