
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
oranges = m.addVar(name="oranges")
grapefruits = m.addVar(name="grapefruits")

# Set objective function
m.setObjective(200 * oranges + 220 * grapefruits, GRB.MAXIMIZE)

# Add constraints
m.addConstr(oranges + grapefruits <= 200, "Total_land")
m.addConstr(oranges >= 60, "Min_oranges")
m.addConstr(grapefruits >= 50, "Min_grapefruits")
m.addConstr(grapefruits <= 2 * oranges, "Grapefruit_limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Oranges: {oranges.x}")
    print(f"Acres of Grapefruits: {grapefruits.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

