
import gurobi

def solve_farmer_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x1 = m.addVar(lb=0, name="oranges")  # acres of oranges
    x2 = m.addVar(lb=0, name="grapefruits")  # acres of grapefruits

    # Objective function: Maximize profit
    m.setObjective(200 * x1 + 220 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(x1 + x2 <= 200, name="total_land")
    m.addConstr(x1 >= 60, name="min_oranges")
    m.addConstr(x2 >= 50, name="min_grapefruits")
    m.addConstr(x2 <= 2 * x1, name="grapefruits_vs_oranges")

    # Update model
    m.update()

    # Solve model
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of oranges: {x1.varValue}")
        print(f"Optimal acres of grapefruits: {x2.varValue}")
        print(f"Max Profit: ${200 * x1.varValue + 220 * x2.varValue}")
    else:
        print("The model is infeasible")

solve_farmer_problem()
