
import gurobipy as gp

# Create a new model
model = gp.Model("ToyProduction")

# Create variables
action_figures = model.addVar(vtype=gp.GRB.CONTINUOUS, name="action_figures")
toy_cars = model.addVar(vtype=gp.GRB.CONTINUOUS, name="toy_cars")


# Set objective function
model.setObjective(2 * action_figures + 3 * toy_cars, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * action_figures + 8 * toy_cars <= 1000, "production_time")
model.addConstr(2 * action_figures + 2.5 * toy_cars <= 1000, "plastic_cost")
model.addConstr(action_figures >= 0, "action_figures_nonnegative")  # Ensure non-negative production
model.addConstr(toy_cars >= 0, "toy_cars_nonnegative")  # Ensure non-negative production


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Action Figures: {action_figures.x}")
    print(f"Number of Toy Cars: {toy_cars.x}")
    print(f"Maximum Earnings: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

