
from gurobipy import *

# Create a new model
m = Model("action_figures_and_toy_cars")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="action_figures")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="toy_cars")

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 8*x2 <= 1000, "production_time")
m.addConstr(2*x1 + 2.5*x2 <= 1000, "plastic_cost")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Action figures to produce: {x1.x}")
    print(f"Toy cars to produce: {x2.x}")
    print(f"Maximum earnings: ${2*x1.x + 3*x2.x}")
else:
    print("No optimal solution found")
