
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="action_figures")
x2 = model.addVar(lb=0, name="toy_cars")

# Define the objective function
model.setObjective(2*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x1 + 8*x2 <= 1000, name="production_time")
model.addConstr(2*x1 + 2.5*x2 <= 1000, name="plastic_cost")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Action figures: {x1.varValue}")
    print(f"Toy cars: {x2.varValue}")
    print(f"Earnings: {2*x1.varValue + 3*x2.varValue}")
else:
    print("No optimal solution found.")
