
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Dose_Optimization")

# Create variables
youth_doses = m.addVar(vtype=GRB.INTEGER, name="youth_doses")
adult_doses = m.addVar(vtype=GRB.INTEGER, name="adult_doses")


# Set objective function
m.setObjective(5 * youth_doses + 3 * adult_doses, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * youth_doses + 35 * adult_doses <= 5000, "Extract_Constraint")
m.addConstr(youth_doses >= 3 * adult_doses, "Demand_Constraint")
m.addConstr(adult_doses >= 10, "Min_Adult_Doses")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Youth Doses: {youth_doses.x}")
    print(f"Adult Doses: {adult_doses.x}")
    print(f"Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

