
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="youth_doses")
x2 = m.addVar(vtype=GRB.INTEGER, name="adult_doses")

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 35*x2 <= 5000, "extract_limit")
m.addConstr(x1 >= 3*x2, "youth_to_adult_ratio")
m.addConstr(x2 >= 10, "adult_doses_minimum")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
