
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="youth_doses")
    x2 = model.addVar(lb=10, name="adult_doses")

    # Objective function: Maximize 5*x1 + 3*x2
    model.setObjective(5*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*x1 + 35*x2 <= 5000, name="extract_constraint")
    model.addConstr(x1 >= 3*x2, name="demand_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
